/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.ObservableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.AtomicThrowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.HalfSerializer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.subjects.PublishSubject;
import dev.compactmods.crafting.lib.reactivex.rxjava3.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableRetryWhen<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler;

    public ObservableRetryWhen(ObservableSource<T> source, Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ObservableSource<?> other;
        Subject<Throwable> signaller = PublishSubject.create().toSerialized();
        try {
            other = Objects.requireNonNull(this.handler.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        RepeatWhenObserver<T> parent = new RepeatWhenObserver<T>(observer, signaller, this.source);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }

    static final class RepeatWhenObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 802743776666017014L;
        final Observer<? super T> downstream;
        final AtomicInteger wip;
        final AtomicThrowable error;
        final Subject<Throwable> signaller;
        final InnerRepeatObserver inner;
        final AtomicReference<Disposable> upstream;
        final ObservableSource<T> source;
        volatile boolean active;

        RepeatWhenObserver(Observer<? super T> actual, Subject<Throwable> signaller, ObservableSource<T> source) {
            this.downstream = actual;
            this.signaller = signaller;
            this.source = source;
            this.wip = new AtomicInteger();
            this.error = new AtomicThrowable();
            this.inner = new InnerRepeatObserver();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this.upstream, d);
        }

        @Override
        public void onNext(T t) {
            HalfSerializer.onNext(this.downstream, t, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable e) {
            DisposableHelper.replace(this.upstream, null);
            this.active = false;
            this.signaller.onNext(e);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.inner);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.inner);
        }

        void innerNext() {
            this.subscribeNext();
        }

        void innerError(Throwable ex) {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onError(this.downstream, ex, (AtomicInteger)this, this.error);
        }

        void innerComplete() {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        final class InnerRepeatObserver
        extends AtomicReference<Disposable>
        implements Observer<Object> {
            private static final long serialVersionUID = 3254781284376480842L;

            InnerRepeatObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(Object t) {
                RepeatWhenObserver.this.innerNext();
            }

            @Override
            public void onError(Throwable e) {
                RepeatWhenObserver.this.innerError(e);
            }

            @Override
            public void onComplete() {
                RepeatWhenObserver.this.innerComplete();
            }
        }
    }
}

